// 统一表单配置文件
// 包含所有20多个表单的配置信息
(function() {
    'use strict';

    // 表单配置定义
    const FORM_CONFIGS = {
        // 财务审批表
        'finance': {
            name: '财务审批表',
            tabTitle: '创建财务审批表',
            tabTitleKeywords: ['财务审批'],
            fields: [
                { type: 'person', inputId: 'approvalNames', hiddenId: 'approvalIds', label: '部门负责人', defaultIds: '568,697', defaultNames: '徐艳艳,王维' },
                { type: 'person', inputId: 'managername', hiddenId: 'managerid', label: '会计', defaultIds: '1704', defaultNames: '凌婷婷' },
                { type: 'person', inputId: 'approvalName2', hiddenId: 'approvalId2', label: '预算审核人', defaultIds: '811', defaultNames: '王磊' },
                { type: 'person', inputId: 'approvalName3', hiddenId: 'approvalId3', label: '批准人', defaultIds: '566', defaultNames: '韩威' },
                { type: 'person', inputId: 'approvalName4', hiddenId: 'approvalId4', label: '企业负责人', defaultIds: '', defaultNames: '' },
                { type: 'person', inputId: 'approvalName5', hiddenId: 'approvalId5', label: '财务负责人', defaultIds: '1395,574', defaultNames: '洪亚萍,刘新宇' },
                { type: 'dept', inputId: 'deptName', hiddenId: 'deptId', label: '费用所属部门', defaultId: '4', defaultName: '上海启迪创业孵化器有限公司' }
            ]
        },

        // 采购审批表
        'purchase-approval': {
            name: '采购审批表',
            tabTitle: '创建采购审批表',
            tabTitleKeywords: ['采购审批'],
            fields: [
                { type: 'person', inputId: 'applyUserName', hiddenId: 'applyUserId', label: '申请人', defaultIds: '572', defaultNames: '王博宇' },
                { type: 'dept', inputId: 'applyDeptName', hiddenId: 'applyDeptId', label: '费用承担部门', defaultId: '4', defaultName: '上海启迪创业孵化器有限公司' },
                { type: 'person', inputId: 'approvalNames', hiddenId: 'approvalIds', label: '审批人', defaultIds: '572', defaultNames: '王博宇' },
                { type: 'person', inputId: 'managername', hiddenId: 'managerid', label: '总经理', defaultIds: '', defaultNames: '金额超过1万需沈总审批' },
                { type: 'person', inputId: 'presidentname', hiddenId: 'presidentid', label: '董事长', defaultIds: '', defaultNames: '金额超过20万需张总审批' }
            ]
        },

        // 采购需求表
        'purchase-request': {
            name: '采购需求表',
            tabTitle: '创建采购需求表',
            tabTitleKeywords: ['采购需求'],
            fields: [
                { type: 'person', inputId: 'applyUserName', hiddenId: 'applyUserId', label: '申请人', defaultIds: '572', defaultNames: '王博宇' },
                { type: 'dept', inputId: 'applyDeptName', hiddenId: 'applyDeptId', label: '费用承担部门', defaultId: '4', defaultName: '上海启迪创业孵化器有限公司' },
                { type: 'person', inputId: 'approvalNames', hiddenId: 'approvalIds', label: '审批人', defaultIds: '572', defaultNames: '王博宇' },
                { type: 'person', inputId: 'managername', hiddenId: 'managerid', label: '总经理', defaultIds: '', defaultNames: '金额超过1万需沈总审批' },
                { type: 'person', inputId: 'presidentname', hiddenId: 'presidentid', label: '董事长', defaultIds: '', defaultNames: '金额超过20万需张总审批' }
            ]
        },

        // 用印章审批表
        'seal-approval': {
            name: '用印章审批表',
            tabTitle: '创建用印章申请',
            tabTitleKeywords: ['用印章'],
            fields: [
                { type: 'person', inputId: 'applyUserName', hiddenId: 'applyUserId', label: '申请人', defaultIds: '572', defaultNames: '王博宇' },
                { type: 'person', inputId: 'approvalNames', hiddenId: 'approvalIds', label: '审批领导', defaultIds: '572', defaultNames: '王博宇' }
            ]
        },

        // 借印章审批
        'borrow-seal': {
            name: '借印章审批',
            tabTitle: '创建借印章审批',
            tabTitleKeywords: ['借印章'],
            fields: [
                { type: 'person', inputId: 'applyUserName', hiddenId: 'applyUserId', label: '申请人', defaultIds: '', defaultNames: '' },
                { type: 'person', inputId: 'approvalNames', hiddenId: 'approvalIds', label: '审批领导', defaultIds: '', defaultNames: '' }
            ]
        },

        // 人员需求申请表
        'person-requirement': {
            name: '人员需求申请表',
            tabTitle: '创建人员需求申请表',
            tabTitleKeywords: ['人员需求'],
            fields: [
                { type: 'dept', inputId: 'applyDeptName', hiddenId: 'applyDeptId', label: '基地（公司）名称', defaultId: '', defaultName: '' },
                { type: 'person', inputId: 'deptmanagername', hiddenId: 'deptmanagerid', label: '副总经理', defaultIds: '', defaultNames: '' },
                { type: 'person', inputId: 'managername', hiddenId: 'managerid', label: '总经理', defaultIds: '', defaultNames: '' },
                { type: 'person', inputId: 'presidentname', hiddenId: 'presidentid', label: '董事长', defaultIds: '', defaultNames: '此处根据实际情况选填：原有岗位人员离职后，替补同岗位人员，无需选择董事长审批' }
            ]
        },

        // 供应商评审表
        'supplier-review': {
            name: '供应商评审表',
            tabTitle: '创建供应商评审表',
            tabTitleKeywords: ['供应商评审'],
            fields: [
                { type: 'person', inputId: 'applyUserName', hiddenId: 'applyUserId', label: '申请人', defaultIds: '', defaultNames: '' },
                { type: 'person', inputId: 'approvalNames', hiddenId: 'approvalIds', label: '前置审批', defaultIds: '572', defaultNames: '王博宇' },
                { type: 'person', inputId: 'managername', hiddenId: 'managerid', label: '总经理', defaultIds: '', defaultNames: '' },
                { type: 'person', inputId: 'presidentname', hiddenId: 'presidentid', label: '董事长', defaultIds: '', defaultNames: '' }
            ]
        },

        // 其他审批
        'other-approval': {
            name: '其他审批',
            tabTitle: '创建其他审批',
            tabTitleKeywords: ['其他审批'],
            fields: [
                { type: 'person', inputId: 'applyUserName', hiddenId: 'applyUserId', label: '申请人', defaultIds: '', defaultNames: '' },
                { type: 'dept', inputId: 'applyDeptName', hiddenId: 'applyDeptId', label: '所属公司', defaultId: '', defaultName: '' },
                { type: 'person', inputId: 'approvalNames', hiddenId: 'approvalIds', label: '审批领导', defaultIds: '', defaultNames: '' }
            ]
        },

        // 出境考察申请
        'overseas-trip': {
            name: '出境考察申请',
            tabTitle: '创建出境考察申请',
            tabTitleKeywords: ['出境考察'],
            fields: [
                { type: 'person', inputId: 'applyUserName', hiddenId: 'applyUserId', label: '申请人', defaultIds: '', defaultNames: '' },
                { type: 'person', inputId: 'approvalNames', hiddenId: 'approvalIds', label: '领队/项目经理', defaultIds: '', defaultNames: '' },
                { type: 'person', inputId: 'managername', hiddenId: 'managerid', label: '主管副总裁', defaultIds: '', defaultNames: '' },
                { type: 'person', inputId: 'managerDname', hiddenId: 'managerDid', label: '总裁', defaultIds: '', defaultNames: '' },
                { type: 'person', inputId: 'presidentname', hiddenId: 'presidentid', label: '董事长', defaultIds: '', defaultNames: '' },
                { type: 'person', inputId: 'commisorName', hiddenId: 'commisorId', label: '政委书记', defaultIds: '', defaultNames: '' }
            ]
        },

        // 出差任务审批表
        'business-trip': {
            name: '出差任务审批表',
            tabTitle: '创建出差任务审批表',
            tabTitleKeywords: ['出差任务'],
            fields: [
                { type: 'person', inputId: 'applyUserName', hiddenId: 'applyUserId', label: '申请人', defaultIds: '', defaultNames: '' },
                { type: 'person', inputId: 'approvalNames', hiddenId: 'approvalIds', label: '部门/项目主管', defaultIds: '', defaultNames: '' },
                { type: 'person', inputId: 'managername', hiddenId: 'managerid', label: '副总经理', defaultIds: '', defaultNames: '' }
            ]
        },

        // 员工休假审批单
        'employee-leave': {
            name: '员工休假审批单',
            tabTitle: '创建员工休假审批单',
            tabTitleKeywords: ['员工休假'],
            fields: [
                { type: 'person', inputId: 'applyUserName', hiddenId: 'applyUserId', label: '申请人', defaultIds: '', defaultNames: '' },
                { type: 'dept', inputId: 'applyDeptName', hiddenId: 'applyDeptId', label: '所属公司', defaultId: '', defaultName: '' },
                { type: 'person', inputId: 'approvalNames', hiddenId: 'approvalIds', label: '部门/项目经理', defaultIds: '', defaultNames: '' },
                { type: 'person', inputId: 'deputyManagerName', hiddenId: 'deputyManagerid', label: '副总经理', defaultIds: '', defaultNames: '' },
                { type: 'person', inputId: 'managername', hiddenId: 'managerid', label: '总经理', defaultIds: '', defaultNames: '' },
                { type: 'person', inputId: 'presidentname', hiddenId: 'presidentid', label: '董事长', defaultIds: '', defaultNames: '' }
            ]
        },

        // 品牌加盟申请审批
        'brand-join': {
            name: '品牌加盟申请审批',
            tabTitle: '创建品牌加盟申请审批',
            tabTitleKeywords: ['品牌加盟'],
            fields: [
                { type: 'person', inputId: 'applyUserName', hiddenId: 'applyUserId', label: '申请人', defaultIds: '', defaultNames: '' },
                { type: 'person', inputId: 'approvalNames', hiddenId: 'approvalIds', label: '审批领导', defaultIds: '', defaultNames: '' },
                { type: 'person', inputId: 'managername', hiddenId: 'managerid', label: '总经理', defaultIds: '', defaultNames: '' }
            ]
        },

        // 大型活动费用决算表
        'activity-account': {
            name: '大型活动费用决算表',
            tabTitle: '创建大型活动费用决算申请',
            tabTitleKeywords: ['活动费用决算'],
            fields: [
                { type: 'person', inputId: 'applyUserName', hiddenId: 'applyUserId', label: '申请人', defaultIds: '', defaultNames: '' },
                { type: 'person', inputId: 'approvalNames', hiddenId: 'approvalIds', label: '审批领导', defaultIds: '', defaultNames: '' }
            ]
        },

        // 大型活动预算审批表申请
        'activity-budget': {
            name: '大型活动预算审批表申请',
            tabTitle: '创建大型活动预算审批表申请',
            tabTitleKeywords: ['活动预算审批'],
            fields: [
                { type: 'person', inputId: 'applyUserName', hiddenId: 'applyUserId', label: '申请人', defaultIds: '', defaultNames: '' },
                { type: 'person', inputId: 'approvalNames', hiddenId: 'approvalIds', label: '审批领导', defaultIds: '', defaultNames: '' },
                { type: 'dept', inputId: 'applyDeptName', hiddenId: 'applyDeptId', label: '承办部门（基地）', defaultId: '', defaultName: '' }
            ]
        },

        // 实习兼职员工录用审批表
        'intern-recruitment': {
            name: '实习兼职员工录用审批表',
            tabTitle: '创建实习、兼职员工录用审批表',
            tabTitleKeywords: ['兼职员工'],
            fields: [
                { type: 'person', inputId: 'deptmanagername', hiddenId: 'deptmanagerid', label: '副总经理', defaultIds: '', defaultNames: '' },
                { type: 'person', inputId: 'managername', hiddenId: 'managerid', label: '总经理', defaultIds: '', defaultNames: '' }
            ]
        },

        // 正式员工录用审批表
        'formal-recruitment': {
            name: '正式员工录用审批表',
            tabTitle: '创建正式员工录用审批表',
            tabTitleKeywords: ['正式员工录用'],
            fields: [
                { type: 'person', inputId: 'deptmanagername', hiddenId: 'deptmanagerid', label: '副总经理', defaultIds: '', defaultNames: '' },
                { type: 'person', inputId: 'managername', hiddenId: 'managerid', label: '总经理', defaultIds: '', defaultNames: '' },
                { type: 'person', inputId: 'presidentname', hiddenId: 'presidentid', label: '董事长', defaultIds: '', defaultNames: '' }
            ]
        },

        // 活动品牌使用审批
        'brand-use': {
            name: '活动品牌使用审批',
            tabTitle: '创建活动品牌使用审批',
            tabTitleKeywords: ['品牌使用'],
            fields: [
                { type: 'person', inputId: 'applyUserName', hiddenId: 'applyUserId', label: '申请人', defaultIds: '', defaultNames: '' },
                { type: 'person', inputId: 'approvalNames', hiddenId: 'approvalIds', label: '审批领导', defaultIds: '', defaultNames: '' },
                { type: 'person', inputId: 'managername', hiddenId: 'managerid', label: '总经理', defaultIds: '', defaultNames: '' }
            ]
        },

        // 用车登记申请表
        'car-registration': {
            name: '用车登记申请表',
            tabTitle: '创建用车登记申请表',
            tabTitleKeywords: ['用车登记'],
            fields: [
                { type: 'person', inputId: 'applyUserName', hiddenId: 'applyUserId', label: '用车人', defaultIds: '', defaultNames: '' },
                { type: 'person', inputId: 'deptmanagername', hiddenId: 'deptmanagerid', label: '部门经理', defaultIds: '', defaultNames: '' }
            ]
        },

        // 离职审批表
        'employee-departure': {
            name: '离职审批表',
            tabTitle: '创建离职审批表',
            tabTitleKeywords: ['离职审批', '离职'],
            fields: [
                { type: 'person', inputId: 'hrdeptname', hiddenId: 'hrdeptid', label: '面谈人', defaultIds: '', defaultNames: '' },
                { type: 'person', inputId: 'deptmanagername', hiddenId: 'deptmanagerid', label: '副总经理', defaultIds: '', defaultNames: '' },
                { type: 'person', inputId: 'managername', hiddenId: 'managerid', label: '总经理', defaultIds: '', defaultNames: '' },
                { type: 'person', inputId: 'presidentname', hiddenId: 'presidentid', label: '董事长', defaultIds: '', defaultNames: '' }
            ]
        },

        // 续签审批表
        'contract-renewal': {
            name: '续签审批表',
            tabTitle: '创建续签审批表',
            tabTitleKeywords: ['续签审批'],
            fields: [
                { type: 'person', inputId: 'deptmanagername', hiddenId: 'deptmanagerid', label: '副总经理', defaultIds: '', defaultNames: '' },
                { type: 'person', inputId: 'managername', hiddenId: 'managerid', label: '总经理', defaultIds: '', defaultNames: '' },
                { type: 'person', inputId: 'presidentname', hiddenId: 'presidentid', label: '董事长', defaultIds: '', defaultNames: '' }
            ]
        },

        // 装修合同审批表
        'decoration-contract': {
            name: '装修合同审批表',
            tabTitle: '创建装修合同审批表',
            tabTitleKeywords: ['装修合同审批'],
            fields: [
                { type: 'person', inputId: 'applyUserName', hiddenId: 'applyUserId', label: '申请人', defaultIds: '', defaultNames: '' },
                { type: 'person', inputId: 'approvalNames', hiddenId: 'approvalIds', label: '前置审批', defaultIds: '572', defaultNames: '王博宇' },
                { type: 'person', inputId: 'financename', hiddenId: 'financeid', label: '财务', defaultIds: '', defaultNames: '' },
                { type: 'person', inputId: 'managername', hiddenId: 'managerid', label: '总经理', defaultIds: '', defaultNames: '' },
                { type: 'person', inputId: 'presidentname', hiddenId: 'presidentid', label: '董事长', defaultIds: '', defaultNames: '' }
            ]
        },

        // 装修工程需求表
        'decoration-project': {
            name: '装修工程需求表',
            tabTitle: '创建装修工程需求表',
            tabTitleKeywords: ['装修工程需求'],
            fields: [
                { type: 'person', inputId: 'applyUserName', hiddenId: 'applyUserId', label: '申请人', defaultIds: '', defaultNames: '' },
                { type: 'dept', inputId: 'applyDeptName', hiddenId: 'applyDeptId', label: '基地（公司）名称', defaultId: '', defaultName: '' },
                { type: 'person', inputId: 'approvalNames', hiddenId: 'approvalIds', label: '前置审批', defaultIds: '572', defaultNames: '王博宇' },
                { type: 'person', inputId: 'managername', hiddenId: 'managerid', label: '总经理', defaultIds: '', defaultNames: '' },
                { type: 'person', inputId: 'presidentname', hiddenId: 'presidentid', label: '董事长', defaultIds: '', defaultNames: '' }
            ]
        },

        // 转正审批表
        'employee-positive': {
            name: '转正审批表',
            tabTitle: '创建转正审批表',
            tabTitleKeywords: ['转正审批'],
            fields: [
                { type: 'person', inputId: 'deptmanagername', hiddenId: 'deptmanagerid', label: '副总经理', defaultIds: '', defaultNames: '' },
                { type: 'person', inputId: 'managername', hiddenId: 'managerid', label: '总经理', defaultIds: '', defaultNames: '' },
                { type: 'person', inputId: 'presidentname', hiddenId: 'presidentid', label: '董事长', defaultIds: '', defaultNames: '' }
            ]
        },

        // 阶段装修验收审批
        'stage-acceptance': {
            name: '阶段装修验收审批',
            tabTitle: '创建阶段装修验收审批',
            tabTitleKeywords: ['装修验收'],
            fields: [
                { type: 'person', inputId: 'applyUserName', hiddenId: 'applyUserId', label: '申请人', defaultIds: '', defaultNames: '' },
                { type: 'person', inputId: 'approvalNames', hiddenId: 'approvalIds', label: '前置审批', defaultIds: '572', defaultNames: '王博宇' },
                { type: 'person', inputId: 'managername', hiddenId: 'managerid', label: '总经理', defaultIds: '', defaultNames: '' },
                { type: 'person', inputId: 'presidentname', hiddenId: 'presidentid', label: '董事长', defaultIds: '', defaultNames: '' }
            ]
        }
    };

    // 导出到全局
    window.FORM_CONFIGS = FORM_CONFIGS;

})();
